//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 17:09:36 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: pendulum_spring_c
//
//	==> Number of joints: 4
//
//	==> Function: F8 - Constraints and Constraints Jacobian(h, J)
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"

void mbs_cons_hJ(double *h, double **Jac,
MbsData *s, double tsim)
{
#include "mbs_cons_hJ_pendulum_spring_c.h"

double *q, *qd;
double **dpt, *lrod;

q = s->q;
qd = s->qd;

dpt = s->dpt;
lrod = s->lrod;
 
// Trigonometric functions

S1 = sin(q[1]);
C1 = cos(q[1]);
S3 = sin(q[3]);
C3 = cos(q[3]);
S4 = sin(q[4]);
C4 = cos(q[4]);
 
// Augmented Joint Position Vectors

Dz23 = q[2]+dpt[3][3];
 
// Augmented Joint Position Vectors

 
// Constraints and Constraints Jacobian

RLlp1_12 = dpt[3][4]*S1;
RLlp1_32 = dpt[3][4]*C1;
ROlp2_72 = C3*S4+S3*C4;
ROlp2_92 = C3*C4-S3*S4;
RLlp2_12 = dpt[3][6]*S3;
RLlp2_32 = dpt[3][6]*C3;
POlp2_12 = RLlp2_12+dpt[1][2];
RLlp2_13 = ROlp2_72*dpt[3][7];
RLlp2_33 = ROlp2_92*dpt[3][7];
POlp2_13 = POlp2_12+RLlp2_13;
POlp2_33 = RLlp2_32+RLlp2_33;
JTlp2_13_1 = RLlp2_32+RLlp2_33;
JTlp2_33_1 = -RLlp2_12-RLlp2_13;
h_1 = -POlp2_13+RLlp1_12;
h_3 = -POlp2_33+RLlp1_32;
h[1] = h_1;
h[2] = h_3;
Jac[1][1] = RLlp1_32;
Jac[1][2] = 0;
Jac[1][3] = -JTlp2_13_1;
Jac[1][4] = -RLlp2_33;
Jac[2][1] = -RLlp1_12;
Jac[2][2] = 0;
Jac[2][3] = -JTlp2_33_1;
Jac[2][4] = RLlp2_13;

// Number of continuation lines = 0

}
